/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.forge.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.tuple.Pair;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Blcks;

public class SolidCoolantCategory
implements IRecipeCategory<Recipe> {
    public static final ResourceLocation GUI_BACK = new ResourceLocation("powah", "textures/gui/jei/misc.png");
    public static final ResourceLocation ID = new ResourceLocation("powah", "solid.coolants");
    private final IDrawable background;
    private final IDrawable icon;

    public SolidCoolantCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(GUI_BACK, 0, 0, 160, 24).addPadding(1, 0, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Blcks.DRY_ICE.get()));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("gui.powah.jei.category.solid.coolant");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)recipe.stack);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = iRecipeLayout.getItemStacks();
        itemStacks.init(0, true, 3, 4);
        itemStacks.set(ingredients);
    }

    public void draw(Recipe recipe, PoseStack matrix, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        minecraft.f_91062_.m_92883_(matrix, I18n.m_118938_((String)"info.lollipop.amount", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"info.lollipop.mb", (Object[])new Object[]{recipe.amount}), 30.0f, 3.0f, 0x444444);
        minecraft.f_91062_.m_92883_(matrix, I18n.m_118938_((String)"info.lollipop.temperature", (Object[])new Object[0]) + ": " + I18n.m_118938_((String)"info.lollipop.temperature.c", (Object[])new Object[]{"" + ChatFormatting.DARK_AQUA + recipe.coldness}), 30.0f, 15.0f, 0x444444);
    }

    public static class Recipe {
        private final ItemStack stack;
        private final int amount;
        private final int coldness;

        public Recipe(ItemStack stack, int amount, int coldness) {
            this.stack = stack;
            this.amount = amount;
            this.coldness = coldness;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getAmount() {
            return this.amount;
        }

        public int getColdness() {
            return this.coldness;
        }
    }

    public static class Maker {
        public static List<Recipe> getBucketRecipes(IIngredientManager ingredientManager) {
            ArrayList<Recipe> recipes = new ArrayList<Recipe>();
            for (ItemStack stack : ingredientManager.getAllIngredients(VanillaTypes.ITEM)) {
                if (!PowahAPI.SOLID_COOLANTS.containsKey(stack.m_41720_().getRegistryName())) continue;
                Pair<Integer, Integer> pr = PowahAPI.getSolidCoolant((ItemLike)stack.m_41720_());
                recipes.add(new Recipe(stack, (Integer)pr.getLeft(), (Integer)pr.getRight()));
            }
            return recipes;
        }
    }
}

